<?php
require_once '../init.php';

$today = date('Y-m-d');
$tomorrow = date('Y-m-d', strtotime('+1 day'));
$day_name = strtolower(date('l', strtotime($tomorrow))); // e.g. wednesday

// === Helper Functions ===
function GetCustomerData($CustomerCode, $mycon) {
    $CustomerCode = mysqli_real_escape_string($mycon, $CustomerCode);
    $CustomerQ = "SELECT * FROM customer_details WHERE customer_code = '$CustomerCode'";
    $ResultCust = mysqli_query($mycon, $CustomerQ);
    return ($ResultCust && mysqli_num_rows($ResultCust) > 0) ? mysqli_fetch_assoc($ResultCust) : [];
}

function GetProductMaterialData($ProductCode, $mycon) {
    $ProductCode = mysqli_real_escape_string($mycon, $ProductCode);
    $ProductQ = "SELECT * FROM material_master WHERE part_no = '$ProductCode'";
    $ResultP = mysqli_query($mycon, $ProductQ);
    return ($ResultP && mysqli_num_rows($ResultP) > 0) ? mysqli_fetch_assoc($ResultP) : [];
}

function GetAvailableQty($ProductCode, $mycon) {
    $ProductCode = mysqli_real_escape_string($mycon, $ProductCode);
    $AvailableQtyQ = "SELECT SUM(quantity) AS AvailableQty FROM temp_split_quantity_putway WHERE product_code = '$ProductCode'";
    $ResultQty = mysqli_query($mycon, $AvailableQtyQ);
    $row = ($ResultQty && mysqli_num_rows($ResultQty) > 0)? mysqli_fetch_assoc($ResultQty) : ['AvailableQty' => 0];
    return $row['AvailableQty'] ?? 0;
}

// === Get all customers with uploads in the last 7 days ===
$getCustomers = "SELECT DISTINCT customer_code, file_ref_num FROM bulk_order_data_tbl WHERE crate_order_date >= DATE_SUB(CURDATE(), INTERVAL 7 DAY)";
// echo $getCustomers; die;
$customersResult = mysqli_query($mycon, $getCustomers);

if (!$customersResult || mysqli_num_rows($customersResult) == 0) {
    echo "⚠️ No customer uploads found in the last 7 days.\n";
    exit;
}

$totalCustomers = mysqli_num_rows($customersResult);
$processedCustomers = 0;

while ($cust = mysqli_fetch_assoc($customersResult)) {
    $CustomerId = $cust['customer_code'];
    $fileRefNo  = $cust['file_ref_num'];

    // === Skip if tomorrow’s order already exists for this customer ===
    $checkExisting = "SELECT order_id FROM order_management WHERE customer_code = '$CustomerId' AND DATE(order_date) = '$tomorrow'";
    
    $exists = mysqli_query($mycon, $checkExisting);
    if ($exists && mysqli_num_rows($exists) > 0) {
        echo "✅ $CustomerId already has an order for $tomorrow.\n";
        continue;
    }

    // === Fetch bulk order data for this customer ===
    $GetCustomerOrders = "SELECT * FROM bulk_order_data_tbl WHERE customer_code = '$CustomerId' AND file_ref_num = '$fileRefNo'";
//   echo  $GetCustomerOrders; die;
    $ResultOrder = mysqli_query($mycon, $GetCustomerOrders);

    if (!$ResultOrder || mysqli_num_rows($ResultOrder) == 0) {
        echo "❌ No product data found for $CustomerId ($fileRefNo).\n";
        continue;
    }

    $customerDetails = GetCustomerData($CustomerId, $mycon);
    if (empty($customerDetails)) {
        echo "❌ Customer details not found for $CustomerId.\n";
        continue;
    }

    // === Create single order for tomorrow ===
    $OrderRefNumber = time() . rand(100, 999);
    $picking_id = 'PL' . time();
    $CityState = $customerDetails['city'].'/'.$customerDetails['state'];

    $order_sql = "INSERT INTO order_management 
        (user_id, warehouse_id, order_type, ref_number, order_menthod, order_date, customer_id, customer_code, created_on, 
        s_contact_person_name, s_address, s_city_state, s_location, s_phone, email, s_area, shipName, ShipAddress, ShipPincode, 
        submit_status, submitted_on, is_generate_picklist, order_status, order_priority, order_booking_type, picking_id) 
        VALUES 
        ('system', '1', '0', '$OrderRefNumber', 'Auto-Generated', '$tomorrow', '" . $customerDetails['customer_id'] . "', 
        '$CustomerId', '$today', '" . $customerDetails['contact_prsn_name'] . "', 
        '" . $customerDetails['billing_address'] . "', '$CityState', 
        '" . $customerDetails['city'] . "', '" . $customerDetails['phone_number'] . "', '" . $customerDetails['email'] . "', 
        '" . $customerDetails['area'] . "', '" . $customerDetails['company_name'] . "', '" . $customerDetails['address1'] . "', 
        '" . $customerDetails['pincode'] . "', '1', '$today', '0', '2', 'Normal', 'Sales Delivery Order', '$picking_id')";

    if (mysqli_query($mycon, $order_sql)) {
        $order_id = mysqli_insert_id($mycon);
        $errorCount = 0;

        while ($prodRow = mysqli_fetch_assoc($ResultOrder)) {
            $ProductDetails = GetProductMaterialData($prodRow['code'], $mycon);
            if (!$ProductDetails) continue;

            $AvailableQty = GetAvailableQty($prodRow['code'], $mycon);
            $qty = (float)$prodRow[$day_name]; // tomorrow’s weekday qty
            $id_packing = 0;

            $OrderProducts = "INSERT INTO order_material 
                (user_id, warehouse_id, ref_number, product_code, product_desc, product_color, product_packing_configuration, 
                avaliable_qty, unit_price, qty, created_on, order_id, customer_code, submit_status, id_packing) 
                VALUES 
                ('system', '1', '$OrderRefNumber', '" . $prodRow['code'] . "', '" . $ProductDetails['desc'] . "', 
                '" . $ProductDetails['color'] . "', '" . $ProductDetails['packing_configuration'] . "', 
                '$AvailableQty', '" . $ProductDetails['price'] . "', '$qty', '$today', '$order_id', '$CustomerId', '1', '$id_packing')";
            
            if (!mysqli_query($mycon, $OrderProducts)) {
                $errorCount++;
            }
        }

        if ($errorCount == 0) {
            echo "✅ $CustomerId → Order created for $tomorrow ($day_name).\n";
        } else {
            echo "⚠️ $CustomerId → Order created but $errorCount products failed.\n";
        }

    } else {
        echo "❌ Failed to create order for $CustomerId.\n";
    }

    $processedCustomers++;
}

echo "\n✅ Cron completed. Processed $processedCustomers / $totalCustomers customers.\n";
?>
