<?php
require_once '../init.php';

if (not_logged_in() === TRUE) {
  header('location: ../index.php');
}

?>
<!DOCTYPE html>
<html lang="en">
    <!--<![endif]-->
    <!-- BEGIN HEAD -->

    <head>
        <meta charset="utf-8" />
        <title><?php echo $header_project_name; ?></title>
        <meta http-equiv="X-UA-Compatible" content="IE=edge">
        <meta content="width=device-width, initial-scale=1" name="viewport" />
        <meta content="<?php echo $wmsData['about_wh']; ?>" name="description" />
        <meta content="Vikas Singh" name="author" />
        <!-- BEGIN GLOBAL MANDATORY STYLES -->
        <link href="http://fonts.googleapis.com/css?family=Open+Sans:400,300,600,700&subset=all" rel="stylesheet" type="text/css" />
        <link href="../assets/global/plugins/font-awesome/css/font-awesome.min.css" rel="stylesheet" type="text/css" />
        <link href="../assets/global/plugins/simple-line-icons/simple-line-icons.min.css" rel="stylesheet" type="text/css" />
        <link href="../assets/global/plugins/bootstrap/css/bootstrap.min.css" rel="stylesheet" type="text/css" />
        <link href="../assets/global/plugins/bootstrap-switch/css/bootstrap-switch.min.css" rel="stylesheet" type="text/css" />
        <!-- END GLOBAL MANDATORY STYLES -->
        <!-- BEGIN PAGE LEVEL PLUGINS -->
        <link href="../assets/global/plugins/datatables/datatables.min.css" rel="stylesheet" type="text/css" />
        <link href="../assets/global/plugins/datatables/plugins/bootstrap/datatables.bootstrap.css" rel="stylesheet" type="text/css" />
        <link href="../assets/global/plugins/bootstrap-datepicker/css/bootstrap-datepicker3.min.css" rel="stylesheet" type="text/css" />
        <!-- END PAGE LEVEL PLUGINS -->
        <!-- BEGIN THEME GLOBAL STYLES -->
        <link href="../assets/global/css/components-md.min.css" rel="stylesheet" id="style_components" type="text/css" />
        <link href="../assets/global/css/plugins-md.min.css" rel="stylesheet" type="text/css" />
        <!-- END THEME GLOBAL STYLES -->
        <!-- BEGIN THEME LAYOUT STYLES -->
        <link href="../assets/layouts/layout/css/layout.min.css" rel="stylesheet" type="text/css" />
        <link href="../assets/layouts/layout/css/themes/darkblue.min.css" rel="stylesheet" type="text/css" id="style_color" />
        <link href="../assets/layouts/layout/css/custom.min.css" rel="stylesheet" type="text/css" />
        <!-- END THEME LAYOUT STYLES -->
		<link id="page_favicon" href="images/favicon.ico" rel="icon" type="image/x-icon" />
		<style>  
		.box  
		{  
			width: 100%;
			padding: 20px;
			background-color: #fff;
			border: 1px solid #ccc;
			border-radius: 5px;
			min-width: 1900px;
		}  
		table.table.table-bordered th {
		background-color: #5cb85cbf;
		color: #fff;
		letter-spacing: 0.4px;
		}

		.overlay {
		  height: 0%;
		  width: 100%;
		  position: fixed;
		  z-index: 1;
		  top: 0;
		  left: 0;
		  background-color: rgb(0,0,0);
		  background-color: rgba(0,0,0, 0.9);
		  overflow-y: hidden;
		  transition: 0.5s;
		}

		.overlay-content {
		  position: relative;
		  top: 25%;
		  width: 100%;
		  text-align: center;
		  margin-top: 30px;
		}

		.overlay a {
		  padding: 8px;
		  text-decoration: none;
		  font-size: 36px;
		  color: #818181;
		  display: block;
		  transition: 0.3s;
		}

		.overlay a:hover, .overlay a:focus {
		  color: #f1f1f1;
		}

		.overlay .closebtn {
		  position: absolute;
		  top: 20px;
		  right: 45px;
		  font-size: 60px;
		}

		@media screen and (max-height: 450px) {
		  .overlay {overflow-y: auto;}
		  .overlay a {font-size: 20px}
		  .overlay .closebtn {
		  font-size: 40px;
		  top: 15px;
		  right: 35px;
		  }
		}
		</style>
		<script>
		function openNav() {
		  document.getElementById("myNav").style.height = "100%";
		}

		function closeNav() {
		  document.getElementById("myNav").style.height = "0%";
		}
		</script>
	</head>
    <!-- END HEAD -->

    <body class="page-header-fixed page-sidebar-closed-hide-logo page-content-white page-sidebar-closed page-md">
	<div id="myNav" class="overlay">
	  <!--<a style="display:none;" href="javascript:void(0)" class="closebtn" onclick="closeNav()">&times;</a>-->
	  <a href="javascript:void(0)" class="closebtn" onclick="closeNav()">&times;</a>
	  <div class="overlay-content">
	   <h1 style="color:white;">
			Loading...
	   <a href="javascript:void(0)" onclick="closeNav()">&times;</a>
	   </h1>
	   
	  </div>
	</div>
        <div class="page-wrapper">
            <!-- BEGIN HEADER -->
			<?php include 'top_menu.php'; ?>
            <!-- END HEADER -->
            <!-- BEGIN HEADER & CONTENT DIVIDER -->
            <div class="clearfix"> </div>
            <!-- END HEADER & CONTENT DIVIDER -->
            <!-- BEGIN CONTAINER -->
            <div class="page-container">
                <!-- BEGIN SIDEBAR -->
				<?php include 'sidebar.php'; ?>
				<!-- END SIDEBAR -->

                <!-- END SIDEBAR -->
                <!-- BEGIN CONTENT -->
                <div class="page-content-wrapper">
                    <!-- BEGIN CONTENT BODY -->
                    <div class="page-content">

                        <div class="row">
                            <div class="col-md-12">
								<div class="page-wrapper">

									<!-- BEGIN HEADER & CONTENT DIVIDER -->
									<div class="clearfix"> </div>
									<!-- END HEADER & CONTENT DIVIDER -->

								</div>
								<!-- END SIDEBAR -->
								<!-- BEGIN CONTENT -->
								<div class="page-content-wrapper">
									<!-- BEGIN CONTENT BODY -->
									<div class="page-content">
										<!-- BEGIN PAGE HEADER-->

										<!-- BEGIN PAGE BAR -->
										<div class="page-bar alert">
											<h2 >Upload Master Data </h2>
										</div>

										<div class="row" style="margin-top: 50px;">
											<div class="col-md-6">
												<form  method="post" enctype="multipart/form-data">
													<label>Auto Generated File Ref. No. for Future use : </label>
													<span><?php echo time(); ?></span>
													<input type="hidden" name="file_ref_num" id="file_ref_num" value="<?php echo time(); ?>" />
													<br /><br />
													<select class="Select_Items form-control" id="sel1" name="master_file">
														<option value="">Select File type</option>
														<option value="Binning Master">Binning Master</option>
														<option value="Customer Master">Customer Master</option>
														<option value="Material Master">Material Master</option>
														<option value="Transporter Master">Transporter Master</option>
														<option value="Unloading Vehicle Type Master">Unloading Vehicle Type Master</option>
														<option value="Vendor Master">Vendor Master</option>
														<option value="Warehouse Client Maters - Unloading_reciver_buyer_details">Warehouse Client Maters - Unloading_reciver_buyer_details</option>
													</select>
													<br /><br />
													Select Excel to upload
													<br /><br />
													<input type="file" name="excel_file" id="excel_file" required accept=".xls, .xlsx" />
												</form>
											</div>
											<div class="col-md-6" style="text-align: right;">
												<a href="master_data.php"><button type="button" class="btn btn-danger">Back</button></a>
											</div>
										</div>
										<div id="result">  

									</div>
									<!-- END CONTENT BODY -->
								</div>
								<!-- END CONTENT -->

							</div>
							<!-- END CONTAINER -->

							<!-- END CONTENT BODY -->
						</div>
					</div>
					<!-- END CONTENT -->

				</div>
				<!-- END CONTAINER -->
			</div>


			<!-- BEGIN CORE PLUGINS -->
			<script src="../assets/global/plugins/jquery.min.js" type="text/javascript"></script>
			<script src="../assets/global/plugins/bootstrap/js/bootstrap.min.js" type="text/javascript"></script>
			<script src="../assets/global/plugins/js.cookie.min.js" type="text/javascript"></script>
			<script src="../assets/global/plugins/jquery-slimscroll/jquery.slimscroll.min.js" type="text/javascript"></script>
			<script src="../assets/global/plugins/jquery.blockui.min.js" type="text/javascript"></script>
			<script src="../assets/global/plugins/bootstrap-switch/js/bootstrap-switch.min.js" type="text/javascript"></script>
			<!-- END CORE PLUGINS -->
			<!-- BEGIN PAGE LEVEL PLUGINS -->
			<script src="../assets/global/scripts/datatable.js" type="text/javascript"></script>
			<script src="../assets/global/plugins/datatables/datatables.min.js" type="text/javascript"></script>
			<script src="../assets/global/plugins/datatables/plugins/bootstrap/datatables.bootstrap.js" type="text/javascript"></script>
			<script src="../assets/global/plugins/bootstrap-datepicker/js/bootstrap-datepicker.min.js" type="text/javascript"></script>
			<!-- END PAGE LEVEL PLUGINS -->
			<!-- BEGIN THEME GLOBAL SCRIPTS -->
			<script src="../assets/global/scripts/app.min.js" type="text/javascript"></script>
			<!-- END THEME GLOBAL SCRIPTS -->
			<!-- BEGIN PAGE LEVEL SCRIPTS -->
			<script src="../assets/pages/scripts/table-datatables-buttons.min.js" type="text/javascript"></script>
			<!-- END PAGE LEVEL SCRIPTS -->
			<!-- BEGIN THEME LAYOUT SCRIPTS -->
			<script src="../assets/layouts/layout/scripts/layout.min.js" type="text/javascript"></script>
			<script src="../assets/layouts/layout/scripts/demo.min.js" type="text/javascript"></script>
			<script src="../assets/layouts/global/scripts/quick-sidebar.min.js" type="text/javascript"></script>
			<script src="../assets/layouts/global/scripts/quick-nav.min.js" type="text/javascript"></script>
			<script>  
			 $(document).ready(function(){  
				  $('#excel_file').change(function(){  
					   $('#export_excel').submit();
					   openNav();			   
				  });  
				  $('#export_excel').on('submit', function(event){  
					   event.preventDefault();  
					   $.ajax({  
							url:"export-master-data.php",  
							method:"POST",  
							data:new FormData(this),  
							contentType:false,  
							processData:false,  
							success:function(data){  
								 $('#result').html(data);  
								 $('#excel_file').val('');
								 closeNav();					 
							}  
					   });  
				  });  
			 });  
			 </script>  

			 <!-- advance_search -->
			 <script type="text/javascript">
				  var divs = ["Div1", "Div2"];
					 var visibleDivId = null;
				function divVisibility(divId) {
				  if(visibleDivId === divId) {
					visibleDivId = null;
				  } else {
					visibleDivId = divId;
				  }
				  hideNonVisibleDivs();
				}
				function hideNonVisibleDivs() {
				  var i, divId, div;
				  for(i = 0; i < divs.length; i++) {
					divId = divs[i];
					div = document.getElementById(divId);
					if(visibleDivId === divId) {
					  div.style.display = "block";
					} else {
					  div.style.display = "none";
					}
				  }
				}
				</script>
			  

				<script type="text/javascript">
					var element = document.getElementsByClassName("nav-list li")[0];
					element.addEventListener("click", myFunction);
					// alert('test...')
					function myFunction(e) {
					var elems = document.querySelector(".active");
						if(elems !=null) {
						  elems.classList.remove("active");
						}
						e.target.className = "active";
						}
				</script>
			<!-- END THEME LAYOUT SCRIPTS -->
    </body>

</html>