<?php
require_once '../../init.php';
require_once 'function.php';

if (not_logged_in() === TRUE) {
    header('location: ../index.php');
}

// Search Data Show
function get_all_no_of_rows($mycon, $srcitem = "", $srcfrom = "", $role_item = "")
{
    $sql_query = "SELECT * FROM dispatch_crate_mapping_tbl WHERE status = 0 " . $srcitem . " " . $srcfrom . " " . $role_item . " ORDER BY id DESC";
    $result = mysqli_query($mycon, $sql_query);
    return ($result) ? mysqli_num_rows($result) : 0;
}

function get_total_no_of_rows($mycon, $srcitem = "", $srcfrom = "", $role_item = "")
{
    $sql_query = "SELECT * FROM dispatch_crate_mapping_tbl WHERE status = 0 " . $srcitem . " " . $srcfrom . " " . $role_item;
    $result = mysqli_query($mycon, $sql_query);
    return ($result) ? mysqli_num_rows($result) : 0;
}


$item_per_page = 20;
//continue only if $_POST is set and it is a Ajax request
if (isset($_POST) && isset($_SERVER['HTTP_X_REQUESTED_WITH']) && strtolower($_SERVER['HTTP_X_REQUESTED_WITH']) == 'xmlhttprequest') {

    if (isset($_POST["page"])) {
        $page_number = filter_var($_POST["page"], FILTER_SANITIZE_NUMBER_INT, FILTER_FLAG_STRIP_HIGH); //filter number
        if (!is_numeric($page_number)) {
            die('Invalid page number!');
        } //incase of invalid page number
    } else {
        $page_number = 1; //if there's no page number, set it to 1
    }

    //Advance Search
    $startHour = "00:00:00";
    $endHour = "23:55:55";
    $srcitem = "";
    if ($_POST['item'] == 'crate_size') {
        $srcitem = " AND crate_size = '" . trim($_POST['colunmData']) . "'";
    } else if ($_POST['item'] == 'all') {
        $srcitem = "";
    }

    if ($_POST['todt'] != '' && $_POST['fromdt'] != '') {
        $srcfrom = "AND created_on BETWEEN '" . $_POST['fromdt'] . " $startHour' AND '" . $_POST['todt'] . " $endHour'";
    } else {
        $srcfrom = '';
    }

    //echo "colunmData--" . $_POST['colunmData'] . "<br/>fromdt--" . $_POST['fromdt'] . "<br/>todt--" . $_POST['todt'] . "<br/>item--" . $_POST['item'];
?>
    <p class="details_table">
        <?php
        if ($_POST['item'] == '') {
            $is_defaultshowEntries = get_total_no_of_rows($mycon, $srcitem, $srcfrom, $role_item);
            if ($is_defaultshowEntries > 20) {
                $defaultshowEntries = 20;
            } else {
                $defaultshowEntries = $is_defaultshowEntries;
            }
        ?>
            <span><b>Searched values : </b> Default Search</span> | <span>Showing <?php echo $defaultshowEntries; ?> by default of </span><span> <?php echo $is_defaultshowEntries; ?></span> <b> entries</b>
        <?php } else { ?>
            <span><b>Searched values : </b> <?php echo $_POST['item'] . " - " . $_POST['colunmData']; ?></span> | <strong>Total Search Data: </strong> <span><?php echo get_all_no_of_rows($mycon, $srcitem, $srcfrom, $role_item); ?></span>| <span><b>Total No. of data :</b> <?php echo get_total_no_of_rows($mycon, $srcitem, $srcfrom, $role_item); ?></span>
        <?php } ?>
    </p>
    <table class="table table-striped table-bordered table-hover dataTable no-footer dtr-inline" id="sample_3" role="grid" aria-describedby="sample_3_info" style="width: 100%;">
        <thead>
            <tr>
                <th>Crate ID </th>
                <th>Order ID </th>
                <th>Challan No </th>
                <th>Part No </th>
                <th>Part Description</th>
                <th>Location</th>
                <th>Crate Box Weight</th>
                <th>Crate Product Weight</th>
                <th>Total Weight</th>
                <th>Sticker Print Count</th>
                <th>Action</th>
            </tr>
        </thead>
        <tbody>

            <?php
            //get total number of records from database for pagination
            $i = 1;
            $sql_query = "SELECT * FROM dispatch_crate_mapping_tbl WHERE status = 0 " . $srcitem . " " . $srcfrom . " " . $role_item . " ORDER BY id DESC";

            $result123 = mysqli_query($mycon, $sql_query);
            $get_total_rows = mysqli_num_rows($result123);
            $total_pages = ceil($get_total_rows / $item_per_page);


            //get starting position to fetch the records
            $page_position = (($page_number - 1) * $item_per_page);

            $sql_query_fetch = "SELECT * FROM dispatch_crate_mapping_tbl WHERE status = 0 " . $srcitem . " " . $srcfrom . " " . $role_item . " ORDER BY id DESC LIMIT $page_position, $item_per_page";
            //   echo  $sql_query_fetch;

            $result_fetch = mysqli_query($mycon, $sql_query_fetch);
            //echo '<br/>' . $sql_query_fetch;
            //echo '<br/>' . $sql_query;
            if (mysqli_num_rows($result_fetch) > 0) {
                while ($row = mysqli_fetch_assoc($result_fetch)) {

            ?>
                    <tr>
                        <td> <?php echo $row['crate_id']; ?></td>
                        <td> <?php echo $row['order_id']; ?></td>
                        <td> <?php echo $row['challan_no']; ?></td>
                        <td> <?php echo $row['part_no']; ?></td>
                        <td> <?php echo $row['part_desc']; ?></td>
                        <td> <?php echo $row['order_location']; ?></td>
                        <td> <?php echo $row['crate_box_weight']; ?></td>
                        <td> <?php echo $row['crate_weight']; ?></td>
                        <td> <?php echo $row['crate_weight'] - $row['crate_box_weight']; ?></td>
                        <td> <?php echo $row['sticker_print_count']; ?></td>
                        <td>


                            <a href="genrate_shipment_print_data.php?crate_id=<?php echo $row['crate_id']; ?>" target="_blank" title="Print Challan" style="display:inline-flex;align-items:center;gap:6px;font-size:16px;font-weight:600; color:#28a745;text-decoration:none;padding:7px 4px;border:2px solid #28a745; border-radius:8px;transition:all 0.3s ease;background:#fff;" onmouseover="this.style.background='#28a745';this.style.color='#fff'; this.querySelector('i').style.color='#fff';  this.querySelector('i').style.transform='scale(1.2)';" onmouseout="this.style.background='#fff';this.style.color='#28a745'; this.querySelector('i').style.color='#28a745'; this.querySelector('i').style.transform='scale(1)';">

                                <i class="fa fa-print"
                                    style="font-size:22px;color:#28a745;transition:transform 0.3s ease,color 0.3s ease;">
                                </i>
                            </a>

                            </a>


                      

                        </td>
                    </tr>
                <?php
                    $cnt++;
                }
            } else {
                ?>
                <tr>
                    <td><?php echo 'No Record Found'; ?></td>
                </tr>
            <?php } ?>
        </tbody>
    </table>
    <div align="center">
        <?php
        /* We call the pagination function here to generate Pagination link for us.
    As you can see I have passed several parameters to the function. */
        echo paginate_function($item_per_page, $page_number, $get_total_rows, $total_pages);
        ?>
    </div>
<?php
}
?>
</div>