<?php
require_once '../init.php';

if (not_logged_in() === TRUE) {
    header('location: ../index.php');
}


function get_total_products_per_challan($mycon, $challan_no)
{
    $challan_no = mysqli_real_escape_string($mycon, $challan_no);
    $sql = "SELECT COUNT(DISTINCT product_code) AS total_product 
            FROM vendor_challan_tbl 
            WHERE challan_no='$challan_no'";
    $result = mysqli_query($mycon, $sql);

    $total = 0;
    if ($row = mysqli_fetch_assoc($result)) {
        $total = $row['total_product'];
    }

    return $total;
}

function get_total_challan_qty($mycon, $challan_no)
{
    $challan_no = mysqli_real_escape_string($mycon, $challan_no);
    $sql = "SELECT SUM(qty) AS total_qty 
            FROM vendor_challan_tbl 
            WHERE challan_no='$challan_no'";
    $result = mysqli_query($mycon, $sql);

    $total_qty = 0;
    if ($result && $row = mysqli_fetch_assoc($result)) {
        $total_qty = (float)$row['total_qty'];
    }

    return $total_qty;
}

// Search Data Show
function get_all_no_of_rows($mycon, $srcitem, $srcfrom, $role_item)
{
    $sql_query = "SELECT * FROM plan_model_mngt 
                  WHERE 1 = 1 " . $srcitem . " " . $srcfrom . " " . $role_item . " 
                  AND uploaded_confirmed= '0'  
                  ORDER BY id DESC";
    $result = mysqli_query($mycon, $sql_query);
    return mysqli_num_rows($result);
}

function get_total_no_of_rows($mycon, $srcitem, $srcfrom, $role_item)
{
    $sql_query = "SELECT * FROM plan_model_mngt 
                  WHERE 1 = 1 " . $role_item . " 
                  AND uploaded_confirmed= '0' ";
    $result = mysqli_query($mycon, $sql_query);
    return mysqli_num_rows($result);
}

//Advance Search
$startHour = "00:00:00";
$endHour = "23:55:55";
$srcitem = "";
if ($_POST['item'] == 'model_name') {
    $srcitem = " AND model = '" . trim($_POST['colunmData']) . "'";
} else if ($_POST['item'] == 'model_description') {
    $srcitem = " AND model_desc = '" . trim($_POST['colunmData']) . "'";
} else if ($_POST['item'] == 'all') {
    $srcitem = "";
}

if ($_POST['todt'] != '' && $_POST['fromdt'] != '') {
    $srcfrom = "AND created_on BETWEEN '" . $_POST['fromdt'] . " $startHour' AND '" . $_POST['todt'] . " $endHour'";
} else {
    $srcfrom = '';
}


if ($_POST['department'] == 'department') {
    require_once 'PHPExcel/Classes/PHPExcel.php';
    $objPHPExcel = new PHPExcel();

    $objPHPExcel->setActiveSheetIndex(0);

    $objPHPExcel->setActiveSheetIndex(0)->mergeCells('A1:D1');
    $objPHPExcel->getActiveSheet()->getCell('A1')->setValue("Report Vendor Challan Report");

    $objPHPExcel->getActiveSheet()
        ->getStyle('A1')
        ->getAlignment()
        ->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);

    $objPHPExcel->getActiveSheet()
        ->getStyle('A1:D1')
        ->getFill()
        ->setFillType(PHPExcel_Style_Fill::FILL_SOLID)
        ->getStartColor()
        ->setARGB('F28A8C');

    // Add function for color	  
    function cellColor($cells, $color)
    {
        global $objPHPExcel;
        $objPHPExcel->getActiveSheet()->getStyle($cells)->getFill()->applyFromArray(array(
            'type' => PHPExcel_Style_Fill::FILL_SOLID,
            'startcolor' => array('rgb' => $color)
        ));
    }

    cellColor('A2:D2', 'D2C9C9');
    cellColor('A3:D3', 'D2C9C9');
    cellColor('A4:D4', 'D2C9C9');
    cellColor('A5:D5', 'D2C9C9');
    cellColor('A6:D6', 'D2C9C9');

    // Borders
    $objPHPExcel->getDefaultStyle()->getBorders()->getTop()->setBorderStyle(PHPExcel_Style_Border::BORDER_THIN);
    $objPHPExcel->getDefaultStyle()->getBorders()->getBottom()->setBorderStyle(PHPExcel_Style_Border::BORDER_THIN);
    $objPHPExcel->getDefaultStyle()->getBorders()->getLeft()->setBorderStyle(PHPExcel_Style_Border::BORDER_THIN);
    $objPHPExcel->getDefaultStyle()->getBorders()->getRight()->setBorderStyle(PHPExcel_Style_Border::BORDER_THIN);

    $styleArray_header = array(
        'font' => array(
            'bold' => true,
            'color' => array('rgb' => '19194d'),
            'size' => 12,
            'name' => 'Verdana'
        ),
        'fill' => array(
            'type' => PHPExcel_Style_Fill::FILL_SOLID,
            'color' => array('rgb' => '9999ff')
        )
    );
    $objPHPExcel->getActiveSheet()->getStyle('A1:D1')->applyFromArray($styleArray_header);

    // Company info (A–D only)
    $objPHPExcel->getActiveSheet()->setCellValue('A2', 'WH Code:');
    $objPHPExcel->getActiveSheet()->setCellValue('B2', $wmsData['warehouse_code']);
    $objPHPExcel->getActiveSheet()->setCellValue('A3', 'Associate Name:');
    $objPHPExcel->getActiveSheet()->setCellValue('B3', $wmsData['company_name']);
    $objPHPExcel->getActiveSheet()->setCellValue('A4', 'Email:');
    $objPHPExcel->getActiveSheet()->setCellValue('B4', $wmsData['email']);
    $objPHPExcel->getActiveSheet()->setCellValue('A5', 'Country:');
    $objPHPExcel->getActiveSheet()->setCellValue('B5', $wmsData['country']);
    $objPHPExcel->getActiveSheet()->setCellValue('A6', 'City:');
    $objPHPExcel->getActiveSheet()->setCellValue('B6', $wmsData['city']);

    $objPHPExcel->setActiveSheetIndex(0)->mergeCells('B2:C2');
    $objPHPExcel->setActiveSheetIndex(0)->mergeCells('B3:C3');
    $objPHPExcel->setActiveSheetIndex(0)->mergeCells('B4:C4');
    $objPHPExcel->setActiveSheetIndex(0)->mergeCells('B5:C5');
    $objPHPExcel->setActiveSheetIndex(0)->mergeCells('B6:C6');

    $objPHPExcel->getActiveSheet()->setCellValue('D2', 'Warehouse Name: ' . $wmsData['warehouse_name']);
    $objPHPExcel->getActiveSheet()->setCellValue('D3', 'Phone: ' . $wmsData['phone_no']);
    $objPHPExcel->getActiveSheet()->setCellValue('D4', 'Address: ' . $wmsData['address']);
    $objPHPExcel->getActiveSheet()->setCellValue('D5', 'State: ' . $wmsData['state']);
    $objPHPExcel->getActiveSheet()->setCellValue('D6', 'Pincode: ' . $wmsData['pincode']);

    // Table Header
    $objPHPExcel->getActiveSheet()->setCellValue('A7', 'PO Number');
    $objPHPExcel->getActiveSheet()->setCellValue('B7', 'Challan No');
    $objPHPExcel->getActiveSheet()->setCellValue('C7', 'Total No Of Product');
    $objPHPExcel->getActiveSheet()->setCellValue('D7', 'Total Challan Qty');

    $style_cell = array(
        'alignment' => array(
            'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,
            'vertical' => PHPExcel_Style_Alignment::VERTICAL_CENTER,
        )
    );

    $styleArray = array(
        'font' => array(
            'bold' => true,
            'color' => array('rgb' => '19194d'),
            'size' => 10,
            'name' => 'Verdana'
        ),
        'fill' => array(
            'type' => PHPExcel_Style_Fill::FILL_SOLID,
            'color' => array('rgb' => 'ccccff')
        )
    );

    $styleArray1 = array(
        'borders' => array(
            'allborders' => array(
                'style' => PHPExcel_Style_Border::BORDER_THIN
            )
        )
    );

    $objPHPExcel->getActiveSheet()->getStyle('A1:D1')->applyFromArray($styleArray1);
    $objPHPExcel->getActiveSheet()->getStyle('A7:D7')->applyFromArray($styleArray1);
    $objPHPExcel->getActiveSheet()->getStyle('A7:D7')->applyFromArray($styleArray);
    $objPHPExcel->getActiveSheet()->getStyle('A7:D7')->applyFromArray($style_cell);
    $objPHPExcel->getActiveSheet()->getStyle('A7:D7')->getAlignment()->setWrapText(true);

    $objPHPExcel->getActiveSheet()->getColumnDimension('A')->setWidth(30);
    $objPHPExcel->getActiveSheet()->getColumnDimension('B')->setWidth(20);
    $objPHPExcel->getActiveSheet()->getColumnDimension('C')->setWidth(20);
    $objPHPExcel->getActiveSheet()->getColumnDimension('D')->setWidth(20);

    $rowCount = 8;

    $sql2 = "SELECT * FROM `vendor_challan_tbl` 
             WHERE vendor_code='$vendor_code' " . $srcitem . " " . $srcfrom . " " . $role_item . " 
             GROUP BY challan_no  
             ORDER BY id DESC";

    $result2 = mysqli_query($mycon, $sql2);
    if (mysqli_num_rows($result2) > 0) {
        while ($row = mysqli_fetch_array($result2)) {

            $objPHPExcel->getActiveSheet()->setCellValue('A' . $rowCount, $row['po_no']);
            $objPHPExcel->getActiveSheet()->setCellValue('B' . $rowCount, $row['challan_no']);
            $objPHPExcel->getActiveSheet()->setCellValue('C' . $rowCount, get_total_products_per_challan($mycon, $row['challan_no']));
            $objPHPExcel->getActiveSheet()->setCellValue('D' . $rowCount, get_total_challan_qty($mycon, $row['challan_no']));

            $styleArrayrows1 = array(
                'borders' => array(
                    'allborders' => array(
                        'style' => PHPExcel_Style_Border::BORDER_THIN
                    )
                )
            );
            $styleArrayrows2 = array(
                'fill' => array(
                    'type' => PHPExcel_Style_Fill::FILL_SOLID
                )
            );

            $objPHPExcel->getActiveSheet()->getStyle('A' . $rowCount . ':D' . $rowCount)->applyFromArray($styleArrayrows1);
            $objPHPExcel->getActiveSheet()->getStyle('A' . $rowCount . ':D' . $rowCount)->applyFromArray($styleArrayrows2);

            $rowCount++;
        }
    } else {
        $objPHPExcel->getActiveSheet()->setCellValue('A' . $rowCount, 'Not Found Data');
        $objPHPExcel->setActiveSheetIndex(0)->mergeCells('A' . $rowCount . ':D' . $rowCount);
        $objPHPExcel->getActiveSheet()->getStyle('A' . $rowCount)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
    }

    $objPHPExcel->getDefaultStyle()->applyFromArray(array(
        'borders' => array(
            'allborders' => array(
                'style' => PHPExcel_Style_Border::BORDER_THIN,
                'color' => array('rgb' => PHPExcel_Style_Color::COLOR_WHITE)
            )
        )
    ));

    $dated = date("Y-m-d h-i-s");
    $file = "Report Vendor Challan Data -" . $dated . ".xlsx";

    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
    header('Content-Disposition: attachment;filename="' . $file . '"');
    header('Cache-Control: max-age=0');
    $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
    ob_end_clean();
    $objWriter->save('php://output');
    exit;
}
