<?php
require_once '../init.php';

header('Content-Type: application/json'); 

$attachment_dir = 'uploads/ConfirmReturnAttachment/';


if (!file_exists($attachment_dir)) {
    mkdir($attachment_dir, 0755, true);
}

function uploadFile($fileField, $upload_dir)
{
    if (!isset($_FILES[$fileField]) || $_FILES[$fileField]['error'] != 0) {
        return '';
    }

    $file_name = basename($_FILES[$fileField]['name']);
    $file_ext = pathinfo($file_name, PATHINFO_EXTENSION);
    $allowed_extensions = ['jpg', 'jpeg', 'png', 'pdf'];

    if (!in_array(strtolower($file_ext), $allowed_extensions)) {
        return '';
    }

    $new_file_name = uniqid($fileField . '_') . '.' . $file_ext;
    $target_file = rtrim($upload_dir, '/') . '/' . $new_file_name;

    if (move_uploaded_file($_FILES[$fileField]['tmp_name'], $target_file)) {
        return $new_file_name;
    } else {
        return '';
    }
}


$verified_by = mysqli_real_escape_string($mycon, $_POST['verified_by']);
$remark = mysqli_real_escape_string($mycon, $_POST['remark']);
$po_no = mysqli_real_escape_string($mycon, $_POST['po_no']);
$supplier_name = mysqli_real_escape_string($mycon, $_POST['supplier_name']);
$vehicle_no = mysqli_real_escape_string($mycon, $_POST['vehicle_no']);
$return_date = mysqli_real_escape_string($mycon, $_POST['return_date']);
$return_qty = mysqli_real_escape_string($mycon, $_POST['return_qty']);
$market_name = mysqli_real_escape_string($mycon, $_POST['market_name']);
$selling_date = mysqli_real_escape_string($mycon, $_POST['selling_date']);
$return_type = mysqli_real_escape_string($mycon, $_POST['return_type']);
$attachment = uploadFile('attachment', $attachment_dir);
$sales_return_id = mysqli_real_escape_string($mycon, $_POST['sales_return_id']);

$return_id = mysqli_real_escape_string($mycon, $_POST['return_id']);
$return_mode = mysqli_real_escape_string($mycon, $_POST['return_mode']);


    $query = "INSERT into `all_qc_rejection_return_tbl` (user_id, warehouse_id, approved_by, all_remarks, po_number, supplier_name, vehicle_no, return_scrap_sale_date, return_scrap_sale_qty, attachment, market_name, sale_value, return_id, return_mode, sales_return_id, return_type, created_at) VALUES ('$userid','$warehouse_id','$verified_by','$remark','$po_no','$supplier_name','$vehicle_no', '$return_date','$return_qty','$attachment','$market_name','$selling_value','$return_id','$return_mode','$sales_return_id','$return_type','$today')";

    $result = mysqli_query($mycon, $query);
   if ($result) {
    echo '1';
} else {
    echo 'Error: ' . mysqli_error($mycon);
}

?>
