<?php
require_once '../init.php';
header('Content-Type: application/json');

$data = json_decode(file_get_contents('php://input'), true);

$warehouse_id = '';

if (isset($data['warehouse_id'])) {
    $warehouse_id = trim($data['warehouse_id']);
} elseif (isset($_POST['warehouse_id'])) {
    $warehouse_id = trim($_POST['warehouse_id']);
}

if ($warehouse_id === '') {
    echo json_encode([
        'success' => false,
        'message' => 'Warehouse ID is required',
        'data' => []
    ]);
    exit;
}

$warehouse_id = mysqli_real_escape_string($mycon, $warehouse_id);

// -------------------------------
// Fetch challan details along with vendor name
// -------------------------------
$sql = "SELECT  invoice_no, SUM(invoice_qty) AS ChallanQty, SUM(grn_rev_qty) AS GRNQty, vendor_name FROM upload_excel WHERE is_comPw = '0' GROUP BY invoice_no";

$result = mysqli_query($mycon, $sql);

if ($result && mysqli_num_rows($result) > 0) {
    $vehicles = [];
    while ($row = mysqli_fetch_assoc($result)) {
        $vehicles[] = [
            'Challan No'     => $row['invoice_no'],
            'TotalChallanQty'  => $row['ChallanQty'],
            'TotalGRNQty'  => $row['GRNQty'], // Added vendor name
            'VendorName'      => $row['vendor_name']
        ];
    }
    echo json_encode([
        'success' => true,
        'message' => 'Challan details Fetched Successfully',
        'data' => $vehicles
    ]);
} else {
    echo json_encode([
        'success' => false,
        'message' => 'No challan details found for this warehouse',
        'data' => []
    ]);
}
?>
