<?php
require_once '../init.php';
header('Content-Type: application/json');

$data = json_decode(file_get_contents('php://input'), true);

$challan_no = '';
$warehouse_id = '';

if (isset($data['challan_no'])) {
    $challan_no = trim($data['challan_no']);
} elseif (isset($_POST['challan_no'])) {
    $challan_no = trim($_POST['challan_no']);
}

if (isset($data['warehouse_id'])) {
    $warehouse_id = trim($data['warehouse_id']);
} elseif (isset($_POST['warehouse_id'])) {
    $warehouse_id = trim($_POST['warehouse_id']);
}

$response = ['success' => false, 'message' => '', 'data' => []];

if ($challan_no === '') {
    $response['message'] = 'Challan no is required';
    echo json_encode($response);
    exit;
}

if ($warehouse_id === '') {
    $response['message'] = 'Warehouse ID is required';
    echo json_encode($response);
    exit;
}

$challan_no = mysqli_real_escape_string($mycon, $challan_no);
$warehouse_id = mysqli_real_escape_string($mycon, $warehouse_id);

$sql_check = "
    SELECT 
        invoice_no, 
        product_code, 
        SUM(qty) AS TotalChallanProductQty, 
        SUM(grn_rev_qty) AS GRNQTY 
    FROM upload_excel 
    WHERE invoice_no = '$challan_no' 
    GROUP BY invoice_no, product_code
";

$result = mysqli_query($mycon, $sql_check);

if ($result && mysqli_num_rows($result) > 0) {
    $products = [];
    while ($row = mysqli_fetch_assoc($result)) {
        $products[] = [
            'Challan no' => $row['invoice_no'],
            'Product code' => $row['product_code'],
            'Total Challan Product Qty' => $row['TotalChallanProductQty'],
            'Total GRN Qty' => $row['GRNQTY'],
        ];
    }

    $response['success'] = true;
    $response['message'] = 'Challan found';
    $response['data'] = $products;
} else {
    $response['message'] = 'Invalid Challan no or Warehouse ID';
}

echo json_encode($response);
?>
