<?php
require_once '../init.php';
header('Content-Type: application/json');

// Read input (JSON or POST)
$data = json_decode(file_get_contents('php://input'), true);

$crate_id = '';
if (isset($data['crate_id'])) {
    $crate_id = trim($data['crate_id']);
} elseif (isset($_POST['crate_id'])) {
    $crate_id = trim($_POST['crate_id']);
}

$response = ['success' => false, 'message' => '', 'data' => []];

if ($crate_id === '') {
    $response['message'] = 'Crate ID is required';
    echo json_encode($response);
    exit;
}

$crate_id = mysqli_real_escape_string($mycon, $crate_id);

$sql_check = "SELECT crate_id,crate_weight FROM dispatch_crate_mapping_tbl WHERE crate_id = '$crate_id'";
$result = mysqli_query($mycon, $sql_check);
//print_r($sql_check); die();
if ($result && mysqli_num_rows($result) > 0) {
    $crate = mysqli_fetch_assoc($result); 
    $response['success'] = true;
    $response['message'] = 'Crate Found';
    $response['data'] = [
        'crate_id' => $crate['crate_id'],
        'crate_weight' => $crate['crate_weight']
    ];
} else {
    $response['message'] = 'Invalid Crate ID';
}

echo json_encode($response);
