<?php
require_once '../init.php';
header('Content-Type: application/json');

$response = ['success' => false, 'message' => '', 'data' => []];

// Read input (JSON or POST form-data)
$data = json_decode(file_get_contents('php://input'), true);

$crate_id          = isset($data['crate_id']) ? trim($data['crate_id']) : (isset($_POST['crate_id']) ? trim($_POST['crate_id']) : '');
$challan_no        = isset($data['challan_no']) ? trim($data['challan_no']) : (isset($_POST['challan_no']) ? trim($_POST['challan_no']) : '');
$sales_delivery_no = isset($data['sales_delivery_no']) ? trim($data['sales_delivery_no']) : (isset($_POST['sales_delivery_no']) ? trim($_POST['sales_delivery_no']) : '');
$location          = isset($data['location']) ? trim($data['location']) : (isset($_POST['location']) ? trim($_POST['location']) : '');
$part_no           = isset($data['part_no']) ? trim($data['part_no']) : (isset($_POST['part_no']) ? trim($_POST['part_no']) : '');
$part_desc         = isset($data['part_desc']) ? trim($data['part_desc']) : (isset($_POST['part_desc']) ? trim($_POST['part_desc']) : '');
$batch_code        = isset($data['batch_code']) ? trim($data['batch_code']) : (isset($_POST['batch_code']) ? trim($_POST['batch_code']) : '');
$weight            = isset($data['weight']) ? trim($data['weight']) : (isset($_POST['weight']) ? trim($_POST['weight']) : '');
$user_id           = isset($data['user_id']) ? (int)$data['user_id'] : (isset($_POST['user_id']) ? (int)$_POST['user_id'] : 0);
$warehouse_id      = isset($data['warehouse_id']) ? (int)$data['warehouse_id'] : (isset($_POST['warehouse_id']) ? (int)$_POST['warehouse_id'] : 0);
$order_id          = isset($data['order_id']) ? (int)$data['order_id'] : (isset($_POST['order_id']) ? (int)$_POST['order_id'] : 0);
$PicklistId        = isset($data['picklist_id']) ? trim($data['picklist_id']) : (isset($_POST['picklist_id']) ? trim($_POST['picklist_id']) : '');

// Validate required fields
if ($crate_id === '' || $part_no === '' || $weight === '' || $order_id === 0 || $user_id === 0 || $warehouse_id === 0 || $PicklistId === '') {
    $response['message'] = 'Crate Id, Part No, Order Id, Crate Weight, User Id, Picklist Id and Warehouse Id are required';
    echo json_encode($response);
    exit;
}

// Escape values
$crate_id          = mysqli_real_escape_string($mycon, $crate_id);
$challan_no        = mysqli_real_escape_string($mycon, $challan_no);
$sales_delivery_no = mysqli_real_escape_string($mycon, $sales_delivery_no);
$location          = mysqli_real_escape_string($mycon, $location);
$part_no           = mysqli_real_escape_string($mycon, $part_no);
$part_desc         = mysqli_real_escape_string($mycon, $part_desc);
$batch_code        = mysqli_real_escape_string($mycon, $batch_code);
$weight            = mysqli_real_escape_string($mycon, $weight);
$PicklistId        = mysqli_real_escape_string($mycon, $PicklistId);

$transaction_id = uniqid("TXN");
$today = date('Y-m-d H:i:s');

// Check if crate already dispatched for same order
$check_sql = "SELECT d.id FROM dispatch_crate_mapping_tbl d INNER JOIN crate_registation_tbl c ON d.crate_id = c.crate_id WHERE d.crate_id = '$crate_id' AND d.order_id = '$order_id' AND c.status IN(1,2)";
$check_result = mysqli_query($mycon, $check_sql);

if ($check_result && mysqli_num_rows($check_result) > 0) {
    $response['message'] = 'This crate has already been scanned for one order';
    echo json_encode($response);
    exit;
}

// Fetch part UOM
$part_uom = '';
$uom_sql = "SELECT base_unit_of_measure FROM material_master WHERE part_no = '$part_no' LIMIT 1";
$uom_result = mysqli_query($mycon, $uom_sql);
if ($uom_result && mysqli_num_rows($uom_result) > 0) {
    $row = mysqli_fetch_assoc($uom_result);
    $part_uom = $row['base_unit_of_measure'];
}

// Fetch crate box weight
$CrateBoxWeight = 0;
$crateSql = "SELECT crate_box_weight FROM crate_registation_tbl WHERE crate_id = '$crate_id' LIMIT 1";
$crate_result = mysqli_query($mycon, $crateSql);
if ($crate_result && mysqli_num_rows($crate_result) > 0) {
    $row = mysqli_fetch_assoc($crate_result);
    $CrateBoxWeight = $row['crate_box_weight'];
}

// Default sticker print count
$sticker_print_count = 1;

// Insert crate mapping
$sql = "INSERT INTO dispatch_crate_mapping_tbl (user_id, warehouse_id, picklist_id, order_id, challan_no, sales_delivery_no, order_location, part_no, part_desc, part_uom, batch_code, crate_id, crate_weight, crate_box_weight, sticker_print_count, dispatch_datetime) VALUES ('$user_id', '$warehouse_id', '$PicklistId', '$order_id', '$challan_no', '$sales_delivery_no', '$location', '$part_no', '$part_desc', '$part_uom','$batch_code', '$crate_id', '$weight','$CrateBoxWeight', '$sticker_print_count', '$today')";

if (mysqli_query($mycon, $sql)) {
    $insert_id = mysqli_insert_id($mycon);

    // Update crate registration
    $update_sql = "UPDATE crate_registation_tbl SET transaction_id = '$transaction_id', operation = 'Outward', status = 1, transaction_datetime = '$today' WHERE crate_id = '$crate_id'";
    mysqli_query($mycon, $update_sql);

    // Insert into crate tracking history
    $tracking_sql = "INSERT INTO crate_tracking_history (user_id, warehouse_id, crate_id, operation, transaction_id, transaction_date_time) VALUES ('$user_id', '$warehouse_id', '$crate_id', 'Outward', '$transaction_id', '$today')";
    mysqli_query($mycon, $tracking_sql);

    // Fetch dispatch datetime
    $datetime_sql = "SELECT created_at FROM dispatch_crate_mapping_tbl WHERE id = $insert_id";
    $datetime_result = mysqli_query($mycon, $datetime_sql);
    $dispatch_datetime = null;
    if ($datetime_result && mysqli_num_rows($datetime_result) > 0) {
        $row = mysqli_fetch_assoc($datetime_result);
        $dispatch_datetime = $row['created_at'];
    }

    // ✅ Calculate total box weight
    $total_box_weight = floatval($weight) - floatval($CrateBoxWeight);

    // Final response
    $response['success'] = true;
    $response['message'] = 'Crate dispatched successfully';
    $response['data'] = [
        'crate_id'          => $crate_id,
        'insert_id'         => $insert_id,
        'DispatchDateTime'  => $dispatch_datetime,
        'uom'               => $part_uom,
        'crate_weight'      => $weight,
        'crate_box_weight'  => $CrateBoxWeight,
        'total_box_weight'  => $total_box_weight
    ];

} else {
    $response['message'] = 'Error inserting crate: ' . mysqli_error($mycon);
}

echo json_encode($response, JSON_PRETTY_PRINT);
?>
