<?php
require_once '../init.php';
header('Content-Type: application/json');

// Get input
$data = json_decode(file_get_contents('php://input'), true);

$page  = isset($data['page']) ? (int)$data['page'] : (isset($_POST['page']) ? (int)$_POST['page'] : 1);
$limit = isset($data['limit']) ? (int)$data['limit'] : (isset($_POST['limit']) ? (int)$_POST['limit'] : 10);

$page  = max($page, 1);
$limit = max($limit, 1);
$offset = ($page - 1) * $limit;

// -------------------------------
// Get total challan count
// -------------------------------
$count_sql = "SELECT COUNT(DISTINCT invoice_no) AS total FROM upload_excel";
$count_result = mysqli_query($mycon, $count_sql);
$count_row = mysqli_fetch_assoc($count_result);
$total_records = (int)$count_row['total'];
$total_pages = ceil($total_records / $limit);

// -------------------------------
// Get challan-wise summary
// -------------------------------
$sql = "SELECT invoice_no, lrno AS lrno,SUM(no_of_boxes) AS total_boxes, SUM(grn_rev_qty) AS total_grn_qty, COUNT(DISTINCT product_code) AS total_products FROM upload_excel GROUP BY invoice_no ORDER BY invoice_no DESC LIMIT $limit OFFSET $offset";

$result = mysqli_query($mycon, $sql);

$data = [];
if ($result && mysqli_num_rows($result) > 0) {
    while ($row = mysqli_fetch_assoc($result)) {
        $data[] = [
            'Challan no' => $row['invoice_no'],
            'GRN No' => $row['lrno'],
            'No of Boxes' => (int)$row['total_boxes'],
            'Total GRN Qty' => (float)$row['total_grn_qty'],
            'Unique Products' => (int)$row['total_products']
        ];
    }
}

// -------------------------------
// JSON Response
// -------------------------------
$response = [
    'success' => true,
    'page' => $page,
    'limit' => $limit,
    'total_records' => $total_records,
    'total_pages' => $total_pages,
    'data' => $data
];

echo json_encode($response, JSON_PRETTY_PRINT);
?>
