<?php
require_once '../init.php';
header('Content-Type: application/json');

$data = json_decode(file_get_contents('php://input'), true);

$warehouse_id = '';
if (isset($data['warehouse_id'])) {
    $warehouse_id = trim($data['warehouse_id']);
} elseif (isset($_POST['warehouse_id'])) {
    $warehouse_id = trim($_POST['warehouse_id']);
}

$response = ['success' => false, 'message' => '', 'data' => []];

if ($warehouse_id === '') {
    $response['message'] = 'Warehouse ID is required';
    echo json_encode($response);
    exit;
}

$warehouse_id = mysqli_real_escape_string($mycon, $warehouse_id);

$sql = "SELECT order_id, ref_number, invoice_number, s_location, s_area FROM order_management WHERE is_dispatched = '0' AND order_status != '1' AND is_generate_picklist = '1' ORDER BY order_id ASC";

$result = mysqli_query($mycon, $sql);

if ($result && mysqli_num_rows($result) > 0) {
    $Orders = [];
    while ($row = mysqli_fetch_assoc($result)) {
        $Orders[] = [
            'OrderId'        => $row['order_id'],
            'SalesDeliveryNo'=> $row['ref_number'],
            'ChallanNo'      => $row['invoice_number'],
            'Location'      => $row['s_location'],
            'KitchenArea'          => $row['s_area']
        ];
    }

    $response['success'] = true;
    $response['message'] = 'Orders fetched successfully';
    $response['data'] = $Orders;
} else {
    $response['message'] = 'No orders found for this warehouse';
}

echo json_encode($response);
