<?php
header('Content-Type: application/json');
session_start();
require_once '../init.php';

$username     = isset($_POST['username']) ? trim($_POST['username']) : '';
$password     = isset($_POST['password']) ? trim($_POST['password']) : '';
$device_token = isset($_POST['device_token']) ? trim($_POST['device_token']) : '';

if (empty($username) || empty($password)) {
    echo json_encode(["status" => false, "message" => "Username and password are required"]);
    exit;
}

$md5_password = md5($password);

// ✅ Check if user exists
$sql = "SELECT * FROM users WHERE username = '" . mysqli_real_escape_string($mycon, $username) . "'";
$result = mysqli_query($mycon, $sql);

if ($result && mysqli_num_rows($result) > 0) {
    $userdata = mysqli_fetch_assoc($result);

    // ✅ Check password
    if ($userdata['password'] !== $md5_password) {
        echo json_encode(["status" => false, "message" => "Invalid username or password"]);
        exit;
    }

    // ✅ Check if user already logged in
    if ($userdata['is_login'] == 2) {
        echo json_encode(["status" => false, "message" => "User ID is already logged in on another device"]);
        exit;
    }

    // ✅ Set session
    $_SESSION['id'] = $userdata['id'];

    // ✅ Update login status
    $queryupdate = "UPDATE users SET is_login = 1, deviceToken = '" . mysqli_real_escape_string($mycon, $device_token) . "', login_time = '" . date('Y-m-d H:i:s') . "' WHERE id='" . $_SESSION['id'] . "'";
    mysqli_query($mycon, $queryupdate);

    // ✅ Get user IP
    $userIp = '';
    if (!empty($_SERVER['HTTP_CLIENT_IP'])) {
        $userIp = $_SERVER['HTTP_CLIENT_IP'];
    } elseif (!empty($_SERVER['HTTP_X_FORWARDED_FOR'])) {
        $userIp = $_SERVER['HTTP_X_FORWARDED_FOR'];
    } else {
        $userIp = $_SERVER['REMOTE_ADDR'];
    }

    $hostname = gethostbyaddr($userIp);
    $today = date('Y-m-d H:i:s');
    $warehouse_id = isset($userdata['warehouse_id']) ? $userdata['warehouse_id'] : null;

    // ✅ Insert log
    $querylog = "INSERT INTO userlog (userId, warehouse_id, userIp, action, access_at) VALUES ('" . $_SESSION['id'] . "', " . ($warehouse_id ? "'" . $warehouse_id . "'" : "NULL") . ", '" . mysqli_real_escape_string($mycon, $userIp) . "', '" . mysqli_real_escape_string($mycon, $hostname) . "', '" . $today . "')";
    mysqli_query($mycon, $querylog);

    // ✅ Return success
    echo json_encode([
        "status" => true,
        "message" => "Login successful",
        "user" => $userdata
    ]);
} else {
    echo json_encode([
        "status" => false,
        "message" => "User not exists"
    ]);
}
