<?php
header('Content-Type: application/json');
require_once '../init.php';

// Get parameter
$vendor_code = isset($_POST['vendor_code']) ? trim($_POST['vendor_code']) : '';

if (empty($vendor_code)) {
    echo json_encode(["status" => false, "message" => "Vendor code is required"]);
    exit;
}

// Initialize response
$response = [
    "status" => true,
    "message" => "Dashboard data fetched successfully",
    "data" => [
        "NewPO" => 0,
        "WIPPO" => 0,
        "ClosedPO" => 0,
        "NoofChallan" => 0,
        "QCRejectionCount" => 0,
        "PendingReturn" => 0
    ]
];

// New No of PO
$sql1 = "SELECT COUNT(*) AS new_po_count FROM po_details p LEFT JOIN vendor_challan_tbl c ON p.po_no = c.po_no WHERE c.po_no IS NULL AND p.vendor_code = '" . mysqli_real_escape_string($mycon, $vendor_code) . "'";
$res1 = mysqli_query($mycon, $sql1);
if ($res1) {
    $row1 = mysqli_fetch_assoc($res1);
    $response['data']['NewPO'] = $row1['new_po_count'];
}


$sql2 = "SELECT COUNT(*) AS wip_po_count FROM po_details p LEFT JOIN vendor_challan_tbl c ON p.po_no = c.po_no WHERE p.vendor_code = '" . mysqli_real_escape_string($mycon, $vendor_code) . "'";
$res2 = mysqli_query($mycon, $sql2);
if ($res2) {
    $row2 = mysqli_fetch_assoc($res2);
    $response['data']['WIPPO'] = $row2['wip_po_count'] ?? 0;
}

$sql3 = "SELECT COUNT(*) AS completed_po_count FROM (SELECT d.id, d.po_no FROM po_details d JOIN po_material m ON d.id = m.po_id LEFT JOIN challan_management c ON d.po_no = c.po_no WHERE d.vendor_code = '" . mysqli_real_escape_string($mycon, $vendor_code) . "' GROUP BY d.id, d.po_no HAVING SUM(m.qty) = IFNULL(SUM(c.qty), 0)) t";
$res3 = mysqli_query($mycon, $sql3);
if ($res3) {
    $row3 = mysqli_fetch_assoc($res3);
    $response['data']['ClosedPO'] = $row3['completed_po_count'];
}

$sql4 = "SELECT COUNT(challan_no) as TotalChallan FROM vendor_challan_tbl WHERE vendor_code = '" . mysqli_real_escape_string($mycon, $vendor_code) . "' GROUP BY challan_no";
$res4 = mysqli_query($mycon, $sql4);
if ($res4) {
    $row4 = mysqli_fetch_assoc($res4);
    $response['data']['NoofChallan'] = $row4['TotalChallan'];
}

$sql5 = "SELECT COUNT(*) as issues FROM complaints WHERE vendor_code = '" . mysqli_real_escape_string($mycon, $vendor_code) . "'";
$res5 = mysqli_query($mycon, $sql5);
if ($res5) {
    $row5 = mysqli_fetch_assoc($res5);
    $response['data']['QCRejectionCount'] = $row5['issues'];
}

$sql6 = "SELECT COUNT(*) as issues FROM complaints WHERE vendor_code = '" . mysqli_real_escape_string($mycon, $vendor_code) . "'";
$res6 = mysqli_query($mycon, $sql6);
if ($res6) {
    $row6 = mysqli_fetch_assoc($res5);
    $response['data']['PendingReturn'] = $row6['issues'];
}
// Return JSON
echo json_encode($response);
