<?php 
require_once 'init.php';

if (logged_in() === TRUE) {
    header('location: admin/dashboard.php');
    exit();
}

date_default_timezone_set('Asia/Kolkata');
$today = date("Y-m-d H:i:s");

$errormsgs = array();

if ($_POST) {
    $username = $_POST['username'];
    $password = $_POST['password'];

    if ($username == "") {
        $errormsgs[] = " * Username Field is Required <br />";
    }

    if ($password == "") {
        $errormsgs[] = " * Password Field is Required <br />";
    }

    if ($username && $password) {
        $is_login_status = 0;
        if ($is_login_status > 0) {
            $errormsgs[] = "User already logged_in";
        } else {
            if (userExists($username) == TRUE) {
                $login = login($username, $password);
                if ($login) {
                    $userdata = userdata($username);
                    $_SESSION['id'] = $userdata['id'];

                    $queryupdate = "UPDATE users SET is_login = 1, login_time = '" . date('Y-m-d H:i:s') . "' WHERE id='" . $_SESSION['id'] . "'";
                    mysqli_query($mycon, $queryupdate);
                    
                    // Get user IP
                    $userIp = '';
                    if (!empty($_SERVER['HTTP_CLIENT_IP'])) {
                        $userIp = $_SERVER['HTTP_CLIENT_IP'];
                    } elseif (!empty($_SERVER['HTTP_X_FORWARDED_FOR'])) {
                        $userIp = $_SERVER['HTTP_X_FORWARDED_FOR'];
                    } else {
                        $userIp = $_SERVER['REMOTE_ADDR'];
                    }
                    
                    $hostname = gethostbyaddr($userIp);
                    
                    $querylog = "INSERT INTO userlog (userId, warehouse_id, userIp, action, access_at) 
                                 VALUES ('" . $_SESSION['id'] . "', " . ($warehouse_id ? "'" . $warehouse_id . "'" : "NULL") . ", 
                                 '" . mysqli_real_escape_string($mycon, $userIp) . "', '$hostname', '" . $today . "')";
                    mysqli_query($mycon, $querylog);

                    header('location: admin/dashboard.php');
                    exit();
                } else {
                    $errormsgs[] = "Incorrect username/password combination";
                }
            } else {
                $errormsgs[] = "Username does not exist";
            }
        }
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8" />
    <title><?php echo $wmsData['warehouse_name']; ?> - Login</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <!-- Google Fonts -->
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;600&display=swap" rel="stylesheet">
    <link id="page_favicon" href="admin/images/favicon.ico" rel="icon" type="image/x-icon" />

    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
            font-family: 'Roboto', sans-serif;
        }

        body {
            height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            background: #5bac8d;
        }

        .container {
            position: relative;
            display: flex;
            width: 950px;
            height: 560px;
            background: #fff;
            border-radius: 15px;
            overflow: hidden;
            box-shadow: 0px 10px 30px rgba(0, 0, 0, 0.15);
        }

        /* Financial Dropdown */
        #financial_selector {
            position: absolute;
            top: 20px;
            right: 20px;
            z-index: 100;
        }

        #financial_selector select {
            padding: 8px 12px;
            border-radius: 6px;
            border: 1px solid #ccc;
            font-size: 14px;
        }

        /* Left with background image */
        .left {
            flex: 1;
            background: url('warehouse_login.jpg') no-repeat center center;
            background-size: cover;
            display: flex;
            align-items: center;
            justify-content: center;
            position: relative;
        }

        .left::before {
            content: "";
            position: absolute;
            top: 0; left: 0; right: 0; bottom: 0;
            background: rgba(0, 0, 0, 0.3); /* Optional dark overlay */
        }

        /* Right Login Form */
        .right {
            flex: 1;
            padding: 50px;
            display: flex;
            flex-direction: column;
            justify-content: center;
            position: relative;
            z-index: 2;
        }

        .right h2 {
            font-size: 28px;
            color: #333;
            margin-bottom: 5px;
        }

        .right p {
            font-size: 16px;
            color: #666;
            margin-bottom: 25px;
        }

        .form-group {
            margin-bottom: 20px;
        }

        .form-group input {
            width: 100%;
            padding: 12px 15px;
            border-radius: 8px;
            border: 1px solid #ddd;
            outline: none;
            font-size: 15px;
        }

        .form-group input:focus {
            border-color: #5bac8d;
        }

        .actions {
            display: flex;
            justify-content: flex-end;
        }

        .actions a {
            font-size: 14px;
            color: #5bac8d;
            text-decoration: none;
        }

        .login-btn {
            width: 100%;
            padding: 14px;
            background: #5bac8d;
            color: #fff;
            border: none;
            border-radius: 8px;
            cursor: pointer;
            font-size: 16px;
            margin-top: 15px;
            transition: 0.3s;
        }

        .login-btn:hover {
            background: #5433d4;
        }

        .create-account {
            text-align: center;
            margin-top: 20px;
            font-size: 14px;
        }

        .create-account a {
            color: #5bac8d;
            font-weight: 600;
            text-decoration: none;
        }

        .error-msg {
            color: red;
            margin-bottom: 10px;
            font-size: 14px;
        }

        @media (max-width: 768px) {
            .container {
                flex-direction: column;
                height: auto;
                width: 90%;
            }

            .left, .right {
                flex: none;
                width: 100%;
                height: 250px;
            }

            .right {
                padding: 30px;
            }
        }
        
   .login-buttons {
    display: flex;
    gap: 15px;
    margin: 10px 0 20px;
}

.login-buttons {
    display: flex;
    gap: 15px;
    margin: 10px 0 20px;
}

.vendor-btn {
    flex: 1;
    text-align: center;
    background: transparent;
    color: #000000;
    padding: 10px 0;
    border-radius: 8px;
    text-decoration: none;
    font-size: 14px;
    transition: 0.3s;
    border : 1px solid #5bac8d;
}

.vendor-btn:hover {
    background-color: #479977;
}

.gnosis-btn {
    flex: 1;
    text-align: center;
    background: #5bac8d;
    color: #fff;
    padding: 10px 0;
    border-radius: 8px;
    text-decoration: none;
    font-size: 14px;
    transition: 0.3s;
}

.gnosis-btn:hover {
    background-color: #479977;
}



    </style>
</head>
<body>
    <div class="container">
        
        <!-- Financial Dropdown -->
        <div id="financial_selector">
            <select id="financial_redirect">
                <option value="">-- Select Financial Year --</option>
                <option value="https://seabirdlogisolutions.in/gvl_22_23">Finance 2022-23</option>
                <option value="https://seabirdlogisolutions.in/gvl_23_25">Finance 2023-25</option>
                <option value="https://seabirdlogisolutions.in/wms_gvl">Finance 2025-26</option>
            </select>
        </div>

        <!-- Left Background Image -->
        <div class="left"></div>

        <!-- Right Login Form -->
        <div class="right">
           
            
            <img src="admin/uploads/ClientLogo/logo.png" alt="Company Logo" style="max-width: 100%; margin: 10px 0;" />
            <div class="login-buttons">
                <a href="index.php" class="gnosis-btn">Gnosis Login</a>
                <a href="associate_login.php" class="vendor-btn">Vendor Login</a>
                
            </div>

            <?php foreach ($errormsgs as $errormsg) { ?>
                <div class="error-msg"><?php echo @$errormsg; ?></div>
            <?php } ?>
            <p style="color:red;"><?php echo @$_GET['session_expired'] . "<br />"; ?></p>

            <form action="<?php echo $_SERVER['PHP_SELF'] ?>" method="POST">
                <div class="form-group">
                    <input type="text" name="username" placeholder="Username" autocomplete="off">
                </div>
                <div class="form-group">
                    <input type="password" name="password" placeholder="Password" autocomplete="off">
                </div>

                <div class="actions">
                    <a href="#">Forgot password?</a>
                </div>

                <button type="submit" name="btnSubmitLogin" class="login-btn">Login</button>
            </form>
        </div>
    </div>

    <script>
        document.getElementById("financial_redirect").addEventListener("change", function () {
            const url = this.value;
            if (url) {
                window.location.href = url;
            }
        });
    </script>
</body>
</html>
